#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	
    
	[TestFixture]
	public class DAL_PatientSpecialInstruction : BaseTest 
	{
		private DataTable _dtPatientSpecialInstruction;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtPatientSpecialInstruction = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PatientSpecialInstruction WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}
		}

		[Test]
		public void GetSpecialInstructionsForPatient_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtPatientSpecialInstruction.Rows[0][TABLES.PatientSpecialInstruction.PatientGuid];

			DataTable dtTest = DAL.PatientSpecialInstruction.GetSpecialInstructionsForPatient(unitGuid);
			
			Assert.AreEqual(12, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecialInstruction.PatientSpecialInstructionGuid), TABLES.PatientSpecialInstruction.PatientSpecialInstructionGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecialInstruction.PatientSpecialInstructions), TABLES.PatientSpecialInstruction.PatientSpecialInstructions);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecialInstruction.CreateDate), TABLES.PatientSpecialInstruction.CreateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecialInstruction.CreateUser), TABLES.PatientSpecialInstruction.CreateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecialInstruction.VistaConversionIndicator), TABLES.PatientSpecialInstruction.VistaConversionIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecialInstruction.InactivationComment), TABLES.PatientSpecialInstruction.InactivationComment);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecialInstruction.InactivateDate), TABLES.PatientSpecialInstruction.InactivateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecialInstruction.InactivateUser), TABLES.PatientSpecialInstruction.InactivateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecialInstruction.DivisionCode), TABLES.PatientSpecialInstruction.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecialInstruction.RecordStatusCode), TABLES.PatientSpecialInstruction.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecialInstruction.RowVersion), TABLES.PatientSpecialInstruction.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecialInstruction.LastUpdateDate), TABLES.PatientSpecialInstruction.LastUpdateDate);
		}

		[Test]
		public void GetSpecialInstructionsForPatient_Fail()
		{
			DataTable dtTest = DAL.PatientSpecialInstruction.GetSpecialInstructionsForPatient(System.Guid.NewGuid());
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}
	}
}

#endif
